@echo off
if "%OS%" == "Windows_NT" setlocal
rem ------------------------------------------------------
rem Start script for the GeoRasterETL
rem Environment Variable Prequisites
rem
rem   ORACLE_HOME     Oracle database installation home.
rem ------------------------------------------------------

if not "%ORACLE_HOME%" =="" goto moreCheck2
echo The ORACLE_HOME environment variable is not defined.
echo This environment variable is needed to run this program.
goto end

:moreCheck2
if exist "%ORACLE_HOME%\jdk\bin\java.exe" goto doneCheck
echo Can't find java.exe.
echo This file is needed to run this program.
goto end

:doneCheck

rem Oracle JDBC and XML parser JARs:
set JARS=%ORACLE_HOME%\jdbc\lib\ojdbc6.jar
set JARS=%JARS%;%ORACLE_HOME%\lib\xmlparserv2.jar
set JARS=%JARS%;%ORACLE_HOME%\lib\xschema.jar
set JARS=%JARS%;%ORACLE_HOME%\lib\xml.jar
set JARS=%JARS%;%ORACLE_HOME%\jlib\jewt4.jar
set JARS=%JARS%;%ORACLE_HOME%\jlib\share.jar

rem GeoRaster JAR: 
set JARS=%JARS%;%ORACLE_HOME%\md\demo\georaster\etl\georaster_etl.jar

rem Third Party jars:
set JARS=%JARS%;%ORACLE_HOME%\md\demo\georaster\etl\gdal\bin\gdal.jar

rem Third Party libraries:
set PATH=%ORACLE_HOME%\md\demo\georaster\etl\gdal\bin;%PATH%
set GDAL_DRIVER_PATH=%ORACLE_HOME%\md\demo\georaster\etl\gdal\bin\gdalplugins

rem Third Party data:
set GDAL_DATA=%ORACLE_HOME%\md\demo\georaster\etl\gdal\data

set GEORASTERETL_CLASS=oracle.spatial.georaster.tools.etl.GeoRasterETL

@echo on

rem Note: jdk1.6 and up is required to run the program.
%ORACLE_HOME%\jdk\bin\java -cp %JARS%  %GEORASTERETL_CLASS% 

:end
